# Deployment Guide

Quick deployment instructions for the Email Sender application.

## Quick Deployment Steps

### 1. Upload Files
- Extract `email-sender.zip` to your web server
- Ensure files are in a web-accessible directory

### 2. Install Dependencies
```bash
cd email-sender
composer install
```

### 3. Configure SMTP
Edit `config.php`:
```php
define('SMTP_HOST', 'your-smtp-server.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'your-email@domain.com');
define('SMTP_PASSWORD', 'your-password');
```

### 4. Set Permissions
```bash
chmod 600 config.php
chmod 644 *.html *.css *.js *.php
```

### 5. Test
- Open the application in your browser
- Send a test email to verify functionality

## File Structure
```
email-sender/
├── index.html          # Main application interface
├── style.css           # Styling and responsive design
├── script.js           # Client-side validation and AJAX
├── send_email.php      # Backend email processing
├── config.php          # SMTP configuration
├── composer.json       # PHP dependencies
├── .htaccess          # Apache configuration
├── README.md          # Project overview
├── INSTALL.md         # Detailed installation guide
├── CONFIG.md          # Configuration reference
└── DEPLOYMENT.md      # This file
```

## Production Checklist
- [ ] SMTP credentials configured
- [ ] Debug mode disabled in config.php
- [ ] File permissions set correctly
- [ ] HTTPS enabled
- [ ] Test email functionality
- [ ] Backup configuration files

For detailed instructions, see INSTALL.md and CONFIG.md.

