# Installation Guide

This guide will walk you through the complete installation process for the Email Sender application.

## System Requirements

### Minimum Requirements
- **PHP**: Version 7.4 or higher
- **Web Server**: Apache 2.4+ or Nginx 1.18+
- **Composer**: Latest version for dependency management
- **Memory**: 128MB PHP memory limit (minimum)
- **Disk Space**: 50MB free space

### Recommended Requirements
- **PHP**: Version 8.0 or higher
- **Extensions**: mbstring, openssl, curl (usually included)
- **Memory**: 256MB PHP memory limit
- **SSL Certificate**: For secure HTTPS connections

## Installation Methods

### Method 1: Manual Installation (Recommended)

#### Step 1: Download and Extract
```bash
# Download the application (if you have a zip file)
unzip email-sender.zip

# Or clone from repository
git clone <repository-url> email-sender

# Navigate to the directory
cd email-sender
```

#### Step 2: Install Dependencies
```bash
# Install PHPMailer via Composer
composer install

# If composer is not installed, install it first:
# curl -sS https://getcomposer.org/installer | php
# php composer.phar install
```

#### Step 3: Configure File Permissions
```bash
# Set proper permissions (Linux/macOS)
chmod 755 .
chmod 644 *.php *.html *.css *.js *.md
chmod 600 config.php  # Secure the config file
```

#### Step 4: Configure SMTP Settings
Edit the `config.php` file with your SMTP details:

```php
// Example for Gmail
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-app-password');
define('DEFAULT_FROM_EMAIL', 'your-email@gmail.com');
```

#### Step 5: Upload to Web Server
```bash
# Using FTP/SFTP
scp -r email-sender/ user@yourserver.com:/var/www/html/

# Or using rsync
rsync -avz email-sender/ user@yourserver.com:/var/www/html/email-sender/
```

### Method 2: Direct Server Installation

#### For cPanel/Shared Hosting:

1. **Upload Files**
   - Compress the `email-sender` folder into a ZIP file
   - Upload via cPanel File Manager
   - Extract in your public_html directory

2. **Install Composer Dependencies**
   - Access Terminal/SSH in cPanel
   - Navigate to the application directory
   - Run: `composer install`

3. **Configure Settings**
   - Edit `config.php` through File Manager
   - Update SMTP credentials

#### For VPS/Dedicated Server:

1. **Prepare Environment**
   ```bash
   # Update system
   sudo apt update && sudo apt upgrade -y
   
   # Install required packages
   sudo apt install apache2 php php-cli php-mbstring php-curl composer -y
   
   # Enable Apache modules
   sudo a2enmod rewrite
   sudo systemctl restart apache2
   ```

2. **Deploy Application**
   ```bash
   # Clone/copy to web directory
   sudo cp -r email-sender /var/www/html/
   
   # Set ownership
   sudo chown -R www-data:www-data /var/www/html/email-sender
   
   # Install dependencies
   cd /var/www/html/email-sender
   sudo -u www-data composer install
   ```

## Configuration

### SMTP Provider Settings

#### Gmail Configuration
```php
define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_USERNAME', 'your-email@gmail.com');
define('SMTP_PASSWORD', 'your-16-digit-app-password');
```

**Important for Gmail:**
- Enable 2-Factor Authentication
- Generate an App Password (not your regular password)
- Use the 16-digit app password in the configuration

#### Outlook/Hotmail Configuration
```php
define('SMTP_HOST', 'smtp-mail.outlook.com');
define('SMTP_PORT', 587);
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_USERNAME', 'your-email@outlook.com');
define('SMTP_PASSWORD', 'your-password');
```

#### Yahoo Configuration
```php
define('SMTP_HOST', 'smtp.mail.yahoo.com');
define('SMTP_PORT', 587);
define('SMTP_ENCRYPTION', 'tls');
define('SMTP_USERNAME', 'your-email@yahoo.com');
define('SMTP_PASSWORD', 'your-app-password');
```

#### Custom SMTP Configuration
```php
define('SMTP_HOST', 'mail.yourdomain.com');
define('SMTP_PORT', 587);  // or 465 for SSL, 25 for non-encrypted
define('SMTP_ENCRYPTION', 'tls');  // or 'ssl' or ''
define('SMTP_USERNAME', 'your-email@yourdomain.com');
define('SMTP_PASSWORD', 'your-password');
```

### Security Configuration

#### Production Settings
```php
// In config.php, set debug mode to false
define('DEBUG_MODE', false);

// Restrict CORS origins (optional)
define('ALLOWED_ORIGINS', 'https://yourdomain.com');
```

#### File Permissions (Linux/macOS)
```bash
# Secure configuration file
chmod 600 config.php

# Standard web files
chmod 644 *.html *.css *.js *.php
chmod 755 .

# Protect vendor directory
chmod -R 755 vendor/
```

## Testing the Installation

### 1. Basic Functionality Test
1. Open your browser and navigate to the application URL
2. Fill out the email form with test data
3. Send a test email to yourself
4. Check for successful delivery

### 2. SMTP Connection Test
Create a simple test script (`test-smtp.php`):

```php
<?php
require_once 'config.php';
require_once 'vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;

$mail = new PHPMailer(true);

try {
    $mail->isSMTP();
    $mail->Host = SMTP_HOST;
    $mail->SMTPAuth = true;
    $mail->Username = SMTP_USERNAME;
    $mail->Password = SMTP_PASSWORD;
    $mail->SMTPSecure = SMTP_ENCRYPTION;
    $mail->Port = SMTP_PORT;
    
    echo "SMTP connection successful!";
} catch (Exception $e) {
    echo "SMTP connection failed: " . $e->getMessage();
}
?>
```

Run this script to verify SMTP connectivity.

### 3. Error Checking
- Check PHP error logs: `/var/log/apache2/error.log`
- Enable debug mode in `config.php` for detailed error messages
- Verify file permissions and ownership

## Troubleshooting

### Common Issues

#### "Composer not found"
```bash
# Install Composer globally
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer
```

#### "PHPMailer class not found"
```bash
# Reinstall dependencies
rm -rf vendor/
composer install
```

#### "SMTP connection failed"
- Verify SMTP credentials
- Check firewall settings (ports 587, 465, 25)
- Ensure less secure app access is enabled (for Gmail)
- Use app passwords instead of regular passwords

#### "Permission denied" errors
```bash
# Fix file permissions
sudo chown -R www-data:www-data /path/to/email-sender
chmod -R 755 /path/to/email-sender
chmod 600 config.php
```

#### "CORS errors" in browser
- Check `ALLOWED_ORIGINS` in `config.php`
- Verify `.htaccess` file is present and readable
- Ensure Apache mod_headers is enabled

### Getting Help

1. **Check Error Logs**: Always check PHP and web server error logs first
2. **Enable Debug Mode**: Set `DEBUG_MODE` to `true` in `config.php`
3. **Test SMTP Separately**: Use the test script provided above
4. **Verify Requirements**: Ensure all system requirements are met

## Security Considerations

### Production Deployment
1. **Disable Debug Mode**: Set `DEBUG_MODE` to `false`
2. **Secure Config File**: Ensure `config.php` has restricted permissions
3. **Use HTTPS**: Always deploy with SSL certificate
4. **Regular Updates**: Keep PHP and dependencies updated
5. **Backup Configuration**: Keep secure backups of your configuration

### Recommended Security Headers
The included `.htaccess` file provides basic security headers. For enhanced security, consider adding:

```apache
Header always set Strict-Transport-Security "max-age=31536000; includeSubDomains"
Header always set Content-Security-Policy "default-src 'self'"
```

## Next Steps

After successful installation:
1. Test email functionality thoroughly
2. Customize the UI if needed (edit `style.css`)
3. Set up monitoring for email delivery
4. Configure backup procedures
5. Document your specific configuration for future reference

Your Email Sender application should now be fully functional and ready for use!

