# Email Sender Application

A simple, elegant email sending frontend with PHP backend and SMTP support. Features a modern, responsive UI and easy configuration for any SMTP provider.

## Features

- ✨ **Modern UI**: Clean, responsive design with smooth animations
- 📧 **SMTP Support**: Works with Gmail, Outlook, Yahoo, and custom SMTP servers
- 🔒 **Secure**: Input validation, CORS protection, and secure file handling
- 📱 **Mobile Friendly**: Fully responsive design for all devices
- ⚡ **Easy Setup**: Simple configuration and installation process
- 🎯 **Real-time Validation**: Client-side form validation with helpful error messages
- 🔄 **Fallback Support**: Automatic fallback to PHP's built-in mail function

## Screenshots

The application features a beautiful gradient background with a glassmorphism design, including:
- Clean form layout with icon-enhanced labels
- Real-time character counter for messages
- Loading animations and success/error feedback
- Smooth hover effects and transitions

## Requirements

- PHP 7.4 or higher
- Web server (Apache/Nginx) with PHP support
- Composer (for PHPMailer installation)
- SMTP server credentials

## Quick Start

1. **Download and Extract**
   ```bash
   # Extract the application files to your web directory
   unzip email-sender.zip
   cd email-sender
   ```

2. **Install Dependencies**
   ```bash
   composer install
   ```

3. **Configure SMTP**
   - Edit `config.php` with your SMTP settings
   - Update email credentials and server details

4. **Deploy**
   - Upload files to your web server
   - Ensure proper file permissions
   - Access via web browser

## Detailed Installation

See [INSTALL.md](INSTALL.md) for complete installation instructions.

## Configuration

See [CONFIG.md](CONFIG.md) for detailed configuration options.

## Support

For issues or questions, please check the documentation files included with this application.

## License

This project is open source and available under the MIT License.

